/*
 * Decompiled with CFR 0.152.
 */
package com.neopsis.envas.weather.openweathermap;

import com.neopsis.envas.weather.openweathermap.BNvOwmProvider;
import com.neopsis.envas.weather.openweathermap.NvOwmException;
import com.neopsis.envas.weather.util.NvBaseReader;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BTime;
import javax.baja.weather.BCurrentConditions;
import javax.baja.weather.BForecast;
import javax.baja.weather.BSunPosition;
import javax.baja.weather.BWeatherState;
import javax.baja.weather.BWindDirection;

public class NvOwmReader
extends NvBaseReader {
    SimpleDateFormat dayFormat = new SimpleDateFormat("yyyyMMdd");

    public void getForecast(ArrayList forecasts, String location, String appid) throws NvOwmException {
        BForecast fc = null;
        String link = "http://api.openweathermap.org/data/2.5/forecast?q=" + location + "&mode=json&units=imperial&appid=" + appid;
        String json = this.read(link);
        try {
            BDouble maxTemp;
            BDouble minTemp;
            if (json != null) {
                JSONObject forecast = new JSONObject(json);
                JSONArray items = forecast.optJSONArray("list");
                minTemp = BDouble.make((double)1000.0);
                maxTemp = BDouble.make((double)-1000.0);
                Date forecastDate = new Date();
                int cod = forecast.getInt("cod");
                boolean gotIt = false;
                fc = new BForecast();
                if (cod != 200) {
                    String errMsg = forecast.optString("message");
                    throw new NvOwmException("API error code=" + cod + "  " + errMsg, BStatus.fault);
                }
                if (items == null) {
                    throw new NvOwmException("Open Weather Map returned no forecast", BStatus.down);
                }
                for (int i = 0; i < items.length(); ++i) {
                    JSONObject mainTemp;
                    long forecastDateJ;
                    JSONObject item = items.getJSONObject(i);
                    Date itemDate = new Date(item.optLong("dt") * 1000L);
                    long itemDateJ = Long.valueOf(this.dayFormat.format(itemDate));
                    if (itemDateJ > (forecastDateJ = Long.valueOf(this.dayFormat.format(forecastDate)).longValue())) {
                        this.sn(fc.getHigh(), maxTemp);
                        this.sn(fc.getLow(), minTemp);
                        fc.setLastUpdate(BAbsTime.now());
                        BNvOwmProvider.setStatus((BComponent)fc, false, false);
                        forecasts.add(fc);
                        fc = new BForecast();
                        forecastDate = itemDate;
                        minTemp = BDouble.make((double)1000.0);
                        maxTemp = BDouble.make((double)-1000.0);
                        gotIt = false;
                    }
                    if (itemDate.getHours() > 10 && itemDate.getHours() < 14 || !gotIt) {
                        JSONObject wind;
                        fc.setDate(BAbsTime.make((long)itemDate.getTime()));
                        JSONObject main = item.optJSONObject("main");
                        if (main != null) {
                            this.sn(fc.getHumidity(), BDouble.make((double)main.optDouble("humidity")));
                        }
                        if ((wind = item.optJSONObject("wind")) != null) {
                            this.sn(fc.getWindSpeed(), BDouble.make((double)wind.optDouble("speed")));
                        }
                        JSONArray weatherList = item.optJSONArray("weather");
                        this.setState(fc.getState(), fc.getWeatherSummary(), weatherList);
                        gotIt = true;
                    }
                    if ((mainTemp = item.optJSONObject("main")) == null) continue;
                    minTemp = BDouble.make((double)Math.min(minTemp.getDouble(), mainTemp.optDouble("temp")));
                    maxTemp = BDouble.make((double)Math.max(maxTemp.getDouble(), mainTemp.optDouble("temp")));
                }
            } else {
                BNvOwmProvider.setStatus(fc, true, false);
                throw new NvOwmException("Open Weather Map returned no forecast data", BStatus.down);
            }
            fc.setLastUpdate(BAbsTime.now());
            this.sn(fc.getHigh(), maxTemp);
            this.sn(fc.getLow(), minTemp);
            BNvOwmProvider.setStatus((BComponent)fc, false, false);
            forecasts.add(fc);
        }
        catch (Exception ex) {
            if (fc != null) {
                BNvOwmProvider.setStatus(fc, false, true);
            }
            throw new NvOwmException(ex.getMessage(), BStatus.fault);
        }
    }

    public void getCurrentConditions(BCurrentConditions cond, BSunPosition sunPos, String location, String appid) throws NvOwmException {
        String link = "http://api.openweathermap.org/data/2.5/weather?q=" + location + "&mode=json&units=imperial&appid=" + appid;
        try {
            JSONObject current;
            String json = this.read(link);
            if (json != null) {
                JSONObject wind;
                current = new JSONObject(json);
                int cod = current.getInt("cod");
                if (cod != 200) {
                    String errMsg = current.optString("message");
                    throw new NvOwmException("API error code=" + cod + "  " + errMsg, BStatus.fault);
                }
                JSONObject coord = current.getJSONObject("coord");
                sunPos.setLatitude(coord.getDouble("lat"));
                sunPos.setLongitude(coord.getDouble("lon"));
                cond.setSun(sunPos.getLongitude(), sunPos.getLatitude());
                JSONObject main = current.getJSONObject("main");
                if (main != null) {
                    this.sn(cond.getPressure(), BDouble.make((double)main.optDouble("pressure")));
                    this.sn(cond.getTemp(), BDouble.make((double)main.optDouble("temp")));
                    this.sn(cond.getHumidity(), BDouble.make((double)main.optDouble("humidity")));
                }
                if ((wind = current.getJSONObject("wind")) != null) {
                    this.sn(cond.getWindSpeed(), BDouble.make((double)wind.optDouble("speed")));
                    this.sn(cond.getWindGust(), BDouble.make((double)wind.optDouble("gust")));
                }
                this.sn(cond.getVisibility(), BDouble.make((double)current.optDouble("visibility")));
                BDouble windDir = BDouble.make((double)wind.optDouble("deg"));
                if (!windDir.equals((Object)BDouble.NaN)) {
                    this.se(cond.getWindDirection(), (BEnum)BWindDirection.makeDegrees((int)windDir.getInt()));
                }
                this.sn(cond.getWindChill(), BDouble.NaN);
                this.sn(cond.getHeatIndex(), BDouble.NaN);
                this.sn(cond.getDewPoint(), BDouble.NaN);
                JSONObject sys = current.optJSONObject("sys");
                if (sys != null) {
                    long sunrise = sys.optLong("sunrise") * 1000L;
                    long sunset = sys.optLong("sunset") * 1000L;
                    if (sunrise != 0L && sunset != 0L) {
                        BAbsTime sunriseTime = BAbsTime.make((long)sunrise);
                        BAbsTime sunsetTime = BAbsTime.make((long)sunset);
                        cond.setSunrise(BTime.make((BAbsTime)sunriseTime));
                        cond.setSunset(BTime.make((BAbsTime)sunsetTime));
                    }
                }
            } else {
                BNvOwmProvider.setStatus((BComponent)cond, true, false);
                throw new NvOwmException("Open Weather Map returned no current data", BStatus.down);
            }
            JSONArray weatherList = current.optJSONArray("weather");
            this.setState(cond.getState(), cond.getWeatherSummary(), weatherList);
            cond.setLastUpdate(BAbsTime.now());
            BNvOwmProvider.setStatus((BComponent)cond, false, false);
        }
        catch (Exception e) {
            BNvOwmProvider.setStatus((BComponent)cond, false, true);
            throw new NvOwmException(e.getMessage(), BStatus.fault);
        }
    }

    private final void sn(BStatusNumeric statusNumeric, BDouble val) throws Exception {
        int i;
        if (val.equals((Object)BDouble.NaN)) {
            statusNumeric = null;
            return;
        }
        int j = i = statusNumeric.getStatus().getBits();
        try {
            statusNumeric.setValue(val.getDouble());
            j &= 0xFFFFFFBF;
        }
        catch (Exception exception) {
            j |= 0x40;
        }
        if (i != j) {
            statusNumeric.setStatus(BStatus.make((int)j));
        }
    }

    private final void sn(BStatusNumeric statusNumeric, String s) throws Exception {
        int i;
        int j = i = statusNumeric.getStatus().getBits();
        try {
            statusNumeric.setValue(Double.parseDouble(s));
            j &= 0xFFFFFFBF;
        }
        catch (Exception exception) {
            j |= 0x40;
        }
        if (i != j) {
            statusNumeric.setStatus(BStatus.make((int)j));
        }
    }

    private final void setState(BStatusEnum statusEnum, BStatusString summary, JSONArray weatherList) throws Exception {
        if (weatherList == null) {
            this.se(statusEnum, (BEnum)BWeatherState.unknown);
            this.ss(summary, "Unknown");
            return;
        }
        JSONObject weather = weatherList.getJSONObject(0);
        String state = weather.optString("description", "");
        if (state != null) {
            this.ss(summary, state);
        }
        int weatherId = weather.getInt("id");
        switch (weatherId) {
            case 200: 
            case 201: 
            case 202: 
            case 210: 
            case 211: 
            case 212: 
            case 221: 
            case 222: 
            case 223: {
                this.se(statusEnum, (BEnum)BWeatherState.thunderstorms);
                break;
            }
            case 300: 
            case 301: 
            case 302: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 321: {
                this.se(statusEnum, (BEnum)BWeatherState.lightRain);
                break;
            }
            case 500: 
            case 501: {
                this.se(statusEnum, (BEnum)BWeatherState.lightRain);
                break;
            }
            case 502: 
            case 503: 
            case 504: 
            case 522: {
                this.se(statusEnum, (BEnum)BWeatherState.heavyRain);
                break;
            }
            case 520: 
            case 521: 
            case 531: 
            case 611: 
            case 612: 
            case 615: 
            case 616: {
                this.se(statusEnum, (BEnum)BWeatherState.rain);
                break;
            }
            case 511: {
                this.se(statusEnum, (BEnum)BWeatherState.freezingRain);
                break;
            }
            case 600: 
            case 601: 
            case 602: 
            case 620: 
            case 621: 
            case 622: {
                this.se(statusEnum, (BEnum)BWeatherState.snow);
                break;
            }
            case 800: {
                this.se(statusEnum, (BEnum)BWeatherState.sunny);
                break;
            }
            case 801: {
                this.se(statusEnum, (BEnum)BWeatherState.partlySunny);
                break;
            }
            case 802: {
                this.se(statusEnum, (BEnum)BWeatherState.partlyCloudy);
                break;
            }
            case 803: {
                this.se(statusEnum, (BEnum)BWeatherState.mostlyCloudy);
                break;
            }
            case 804: {
                this.se(statusEnum, (BEnum)BWeatherState.overcast);
                break;
            }
            case 701: {
                this.se(statusEnum, (BEnum)BWeatherState.misty);
                break;
            }
            case 741: {
                this.se(statusEnum, (BEnum)BWeatherState.fog);
                break;
            }
            case 721: {
                this.se(statusEnum, (BEnum)BWeatherState.haze);
                break;
            }
            case 761: {
                this.se(statusEnum, (BEnum)BWeatherState.dust);
                break;
            }
            case 762: {
                this.se(statusEnum, (BEnum)BWeatherState.volcano);
                break;
            }
            case 781: {
                this.se(statusEnum, (BEnum)BWeatherState.tornado);
                break;
            }
            case 771: {
                this.se(statusEnum, (BEnum)BWeatherState.thunderstorms);
                break;
            }
            default: {
                this.se(statusEnum, null);
            }
        }
    }

    private final void se(BStatusEnum statusEnum, BEnum anEnum) throws Exception {
        int i;
        int j = i = statusEnum.getStatus().getBits();
        if (anEnum != null) {
            statusEnum.setValue(anEnum);
            j &= 0xFFFFFFBF;
        } else {
            j |= 0x40;
        }
        if (i != j) {
            statusEnum.setStatus(BStatus.make((int)j));
        }
    }

    private final void ss(BStatusString statusString, String str) throws Exception {
        int i;
        int j = i = statusString.getStatus().getBits();
        if (str != null) {
            statusString.setValue(str);
            j &= 0xFFFFFFBF;
        } else {
            j |= 0x40;
        }
        if (i != j) {
            statusString.setStatus(BStatus.make((int)j));
        }
    }
}

