/*
 * Decompiled with CFR 0.152.
 */
package com.neopsis.envas.weather.openweathermap;

import com.neopsis.envas.weather.openweathermap.NvOwmException;
import com.neopsis.envas.weather.openweathermap.NvOwmReader;
import com.neopsis.envas.weather.util.NvLog;
import java.util.ArrayList;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.weather.BCurrentConditions;
import javax.baja.weather.BForecast;
import javax.baja.weather.BSunPosition;
import javax.baja.weather.BWeatherProvider;
import javax.baja.weather.BWeatherReport;

public class BNvOwmProvider
extends BWeatherProvider {
    public static final Property location = BNvOwmProvider.newProperty((int)0, (String)"", null);
    public static final Property apiKey = BNvOwmProvider.newProperty((int)0, (String)"", null);
    public static final Property faultCause = BNvOwmProvider.newProperty((int)0, (String)"", null);
    public static final Type TYPE = Sys.loadType(BNvOwmProvider.class);

    public String getLocation() {
        return this.getString(location);
    }

    public void setLocation(String v) {
        this.setString(location, v, null);
    }

    public String getApiKey() {
        return this.getString(apiKey);
    }

    public void setApiKey(String v) {
        this.setString(apiKey, v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void updateReport() {
        BWeatherReport weatherReport = (BWeatherReport)this.getParent();
        NvOwmReader weatherReader = new NvOwmReader();
        ArrayList forecasts = new ArrayList();
        BCurrentConditions cond = weatherReport.getCurrent();
        BSunPosition sunPosition = new BSunPosition();
        BForecast[] forecastArr = new BForecast[]{};
        try {
            weatherReader.getCurrentConditions(cond, sunPosition, this.getLocation(), this.getApiKey());
            weatherReader.getForecast(forecasts, this.getLocation(), this.getApiKey());
            forecastArr = forecasts.toArray(new BForecast[forecasts.size()]);
            for (int j = 0; j < forecastArr.length; ++j) {
                BForecast forecast = forecastArr[j];
                sunPosition.doRecalculate(forecast.getDate());
                forecast.setSunrise(BTime.make((BAbsTime)sunPosition.getSunrise()));
                forecast.setSunset(BTime.make((BAbsTime)sunPosition.getSunset()));
            }
            weatherReport.setStatus(BStatus.ok);
            this.setFaultCause("");
        }
        catch (NvOwmException ex) {
            NvLog.error("Read forecast failed: " + ex.getMessage());
            weatherReport.setStatus(ex.getStatus());
            this.setFaultCause(ex.getMessage());
        }
        weatherReport.setForecast(forecastArr);
    }

    static void setStatus(BComponent comp, boolean isDown, boolean isFault) {
        BStatus status = (BStatus)comp.get("status");
        if (status != null) {
            int i;
            int j = i = status.getBits();
            j = isDown ? (j |= 4) : (j &= 0xFFFFFFFB);
            j = isFault ? (j |= 2) : (j &= 0xFFFFFFFD);
            if (i != j) {
                comp.set("status", (BValue)BStatus.make((int)j));
            }
        }
        SlotCursor slotcursor = comp.getSlots();
        while (slotcursor.next()) {
            int k;
            if (!(slotcursor.get() instanceof BStatusValue)) continue;
            BStatusValue statusValue = (BStatusValue)slotcursor.get();
            int l = k = statusValue.getStatus().getBits();
            l = isDown ? (l |= 4) : (l &= 0xFFFFFFFB);
            l = isFault ? (l |= 2) : (l &= 0xFFFFFFFD);
            if (k == l) continue;
            statusValue.setStatus(BStatus.make((int)l));
        }
    }

    public String toString(Context context) {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append("Open Weather Map Service: ").append(this.getLocation());
        return stringbuffer.toString();
    }
}

